<?php

class Response
{
    public static function json($data = [], int $code = 200)
    {
        http_response_code($code);
        header('Content-Type: application/json; charset=utf-8');

        echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        exit;
    }

    public static function success(array $data = [])
    {
        self::json([
            'ok' => true,
            'data' => $data
        ]);
    }

    public static function error(string $message, int $code = 400)
    {
        self::json([
            'ok' => false,
            'error' => $message
        ], $code);
    }
}
