<?php

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../src/Response.php';
require_once __DIR__ . '/../src/Validator.php';

$config = require __DIR__ . '/../config.php';

$url = $_GET['url'] ?? null;

// تست زنده بودن API
if (!$url) {
    Response::success([
        'api'     => $config['api_name'],
        'version' => $config['version'],
        'message' => 'API is working'
    ]);
}

// اعتبارسنجی لینک
if (!Validator::youtubeUrl($url)) {
    Response::error('Invalid YouTube URL');
}

// فعلاً فقط تایید می‌کنیم لینک اوکیه
Response::success([
    'message' => 'Valid YouTube URL',
    'url' => $url
]);
